<?php
/**
Plugin Name: افزونه اختصاصی سایت اماده آموزشی ابزار وردپرس
Plugin URI: https://abzarwp.com/
Description: این افزونه برای سایت آماده آموزشی با سیستم لرن دش ایجاد شده است.
Version: 1.0.0
Author:AbzarWP
Author URI: https://abzarwp.com/
*/


# --- ACF Shortcode
add_shortcode( 'abzarwp_acf_sh', function ( $attrs ) {

	if ( ! function_exists( 'get_field' ) ) {
		return false;
	}

	$attrs = wp_parse_args( $attrs, [
		'shortcode' => '',
	] );

	$shortcode = $attrs['shortcode'];

	unset( $attrs['shortcode'] );

	if ( empty( $shortcode ) ) {
		return false;
	}

	$params = [];

	foreach ( $attrs as $param => $value ) {

		if ( stripos( $value, 'acf-' ) !== false ) {
			$value = get_field( str_replace( 'acf-', '', $value ) );
		}

		$params[] = sprintf( '%s="%s"', $param, $value );

	}

	$params    = implode( ' ', $params );
	$shortcode = sprintf( '[%s %s]', $shortcode, $params );

	return do_shortcode( $shortcode );

} );



add_action( 'init', function () {

	// شرتکد برای افزودن به سبد خرید
	add_shortcode( 'abzarwp_learndash_add_to_cart', function ( $atts ) {

		$atts = shortcode_atts( [
			'product_id' => '0',
		], $atts );


		$atts['product_id'] = sanitize_text_field( $atts['product_id'] );

		$url = home_url() . '/cart/?add-to-cart=' . $atts['product_id'];
		$url = esc_url( $url );

		return $url;
	} );

}, 999 );

// https://prnt.sc/26c7x8j در این تصویر استفاده می شود

add_filter( 'abzarwp_learndash_settings_filter', function ( $meta, $backtrace ) {

	if ( ! is_array( $meta ) ) {
		return $meta;
	}

	// در صفحه تنظیمات شرکتد نباید رندر شود
	if ( stripos( $backtrace[0]['file'], 'settings/class-ld-settings-metaboxes.php' ) === false ) {

		if ( isset( $meta['sfwd-courses_custom_button_url'] ) ) {
			$meta['sfwd-courses_custom_button_url'] = do_shortcode( $meta['sfwd-courses_custom_button_url'] );
		}

	}

	return $meta;
}, 999 , 2);


// GF auto login

add_action( 'gform_user_registered', 'we_autologin_gfregistration', 10, 4 );
/**
 * Auto login to site after GF User Registration Form Submittal
 */
function we_autologin_gfregistration( $user_id, $config, $entry, $password ) {
	wp_set_auth_cookie( $user_id, true, '' );
}


// remove 'add to cart' button that show after the content 
add_action( 'plugins_loaded', function (  ){
	remove_action( 'edd_after_download_content', 'edd_append_purchase_link', 10 );
}, 999 );

// course star rating
add_action( 'init', function () {
	add_shortcode( 'abzarwp_show_post_rating', function (  ) {
	$ratingstar = get_field( 'post_rating' );

	ob_start();
	?>

        <span class="fas fa-star <?php if ( $ratingstar >= 1 ) {
			echo 'checked';
		} ?>"></span>
        <span class="fas fa-star <?php if ( $ratingstar >= 2 ) {
			echo 'checked';
		} ?>"></span>
        <span class="fas fa-star <?php if ( $ratingstar >= 3 ) {
			echo 'checked';
		} ?>"></span>
        <span class="fas fa-star <?php if ( $ratingstar >= 4 ) {
			echo 'checked';
		} ?>"></span>
        <span class="fas fa-star <?php if ( $ratingstar == 5 ) {
			echo 'checked';
		} ?>"></span>


		<?php
		$markup = ob_get_clean();
		return $markup;
	} );

}, 999 );

// LearnDash Shortcode Generator
add_action( 'init', function () {

  add_shortcode( 'abzarwp_learndash_profile_stats', function ( $attrs ) {
    
    $attrs = shortcode_atts( [
      'type' => '0',
    ], $attrs );


    if ( $attrs['type'] === '0' ) {
      return '';
    }

    $user_id = get_current_user_id();

    $learndash_profile_stats = learndash_get_user_stats( $user_id );

    $learndash_profile_stats = apply_filters( 'learndash_profile_stats', $learndash_profile_stats, $user_id );


    $courses      = $learndash_profile_stats['courses'];
    $completed    = $learndash_profile_stats['completed'];
    $points       = $learndash_profile_stats['points'];
    $certificates = $learndash_profile_stats['certificates'];


    switch ( $attrs['type'] ) {
      case "courses":
        return $courses;
      case "completed":
        return $completed;

      case "points":
        return $points;

      case "certificates":
        return $certificates;

      default:
        return '';
    }

  } );

}, 999 );


add_action( 'init', function () {

  add_shortcode( 'abzarwp_learndash_profile_courses', function ( $attrs ) {

    $user_id       = get_current_user_id();
    $user_courses  = ld_get_mycourses( $user_id, $attrs );
    $quiz_attempts = get_user_meta( $user_id, '_sfwd-quizzes', true );

    ob_start();
    ?>
        <div class="learndash-wrapper">
            <div class="ld-item-list ld-course-list">

                <div class="ld-section-heading">
                    <h3>
            <?php
            printf(
            // translators: Profile Course Content Label.
              esc_html_x( 'Your %s', 'Profile Course Content Label', 'learndash' ),
              esc_attr( LearnDash_Custom_Label::get_label( 'courses' ) )
            );
            ?>
                    </h3>
                    <div class="ld-item-list-actions">
            <?php if ( isset( $shortcode_atts['show_search'] ) && 'yes' === $shortcode_atts['show_search'] ) { ?>
                            <button class="ld-search-prompt ld-icon-search ld-icon" data-ld-expands="ld-course-search" aria-label="
            <?php
              printf(
              // translators: placeholder: Profile Search Prompt Label.
                esc_html_x( 'Show %s Search Field', 'placeholder: Profile Search Prompt Label', 'learndash' ),
                esc_attr( LearnDash_Custom_Label::get_label( 'courses' ) )
              );
              ?>
          ">
                            </button> <!--/.ld-search-prompt-->
            <?php } ?>
                        <div class="ld-expand-button" data-ld-expands="ld-main-course-list" data-ld-expand-text="<?php echo esc_attr_e( 'Expand All', 'learndash' ); ?>" data-ld-collapse-text="<?php echo esc_attr_e( 'Collapse All', 'learndash' ); ?>">
                            <span class="ld-icon-arrow-down ld-icon"></span>
                            <span class="ld-text"><?php echo esc_html_e( 'Expand All', 'learndash' ); ?></span>
                        </div> <!--/.ld-expand-button-->
                    </div> <!--/.ld-course-list-actions-->
                </div> <!--/.ld-section-heading-->
        <?php
        if ( isset( $shortcode_atts['show_search'] ) && 'yes' === $shortcode_atts['show_search'] ) {
          learndash_get_template_part(
            'shortcodes/profile/search.php',
            [
              'user_id'      => $user_id,
              'user_courses' => $user_courses,
            ],
            true
          );
        }
        ?>

                <div class="ld-item-list-items" id="ld-main-course-list" data-ld-expand-list="true">

          <?php
          if ( ! empty( $user_courses ) ) :
            foreach ( $user_courses as $learndash_course_id ) :

              learndash_get_template_part(
                'shortcodes/profile/course-row.php',
                [
                  'user_id'        => $user_id,
                  'course_id'      => $learndash_course_id,
                  'quiz_attempts'  => $quiz_attempts,
                 // 'shortcode_atts' => $shortcode_atts,
                ],
                true
              );

            endforeach;
          else :

            $learndash_no_courses_found_alert = [
              'icon'    => 'alert',
              // translators: placeholder: Courses.
              'message' => sprintf( esc_html_x( 'No %s found', 'placeholder: Courses', 'learndash' ), LearnDash_Custom_Label::get_label( 'courses' ) ), // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Method escapes output
              'type'    => 'warning',
            ];
            learndash_get_template_part( 'modules/alert.php', $learndash_no_courses_found_alert, true );

          endif;
          ?>

                </div> <!--/.ld-course-list-items-->

            </div> <!--/ld-course-list-->
        </div>
    <?php
    $markup = ob_get_clean();

    return $markup;

  } );

}, 999 );

// Show Gravatar Shortcode
function shortcode_user_avatar() {
  if(is_user_logged_in()) { // check if user is logged in
    global $current_user; // get current user's information
    wp_get_current_user();
    return get_avatar( $current_user -> ID, 90 ); // display the logged in user's avatar
  }
  else {
    // if not logged in, show default avatar. change URL to show your own default avatar
    return get_avatar( 'http://1.gravatar.com/avatar/ad524503a11cd5ca435acc9bb6523536?s=64', 90 );
  }
}
add_shortcode('display-user-avatar','shortcode_user_avatar');

//Change Currency in Course
add_filter( 'AbzarWp/Learndash/currency', function ( $currency ) {
  $currency = 'تومان';
    return $currency;
}, 999 );